<script>
    // cart items element
    class ProductListElement extends SuperElement  {
        name() {
            return getI18n('block');
        }
        icon() {
            return 'fal fa-font';
        }

        getOptions() {
            return {
                preview: this.obj.attr('data-preview'),
                count: this.obj.attr('data-count'),
                cols: this.obj.attr('data-cols'),
                sort: this.obj.attr('data-sort')
            };
        }

        setOptions(options) {
            if (typeof(options.preview) != 'undefined') {
                this.obj.attr('data-preview', options.preview);
            }
            if (typeof(options.count) != 'undefined') {
                this.obj.attr('data-count', options.count);
            }
            if (typeof(options.cols) != 'undefined') {
                this.obj.attr('data-cols', options.cols);
            }
            if (typeof(options.sort) != 'undefined') {
                this.obj.attr('data-sort', options.sort);
            }

            this.render();
        }

        addLoadingEffect() {
            var _this = this;

            this.removeLoadingEffect();

            _this.obj.addClass('ace-loading');
            _this.obj.append(`<div class="ace-loader"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background-image: none; display: block; shape-rendering: auto;" width="200px" height="200px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid">
                <circle cx="30" cy="50" fill="#774023" r="20">
                <animate attributeName="cx" repeatCount="indefinite" dur="1s" keyTimes="0;0.5;1" values="30;70;30" begin="-0.5s"/>
                </circle>
                <circle cx="70" cy="50" fill="#d88c51" r="20">
                <animate attributeName="cx" repeatCount="indefinite" dur="1s" keyTimes="0;0.5;1" values="30;70;30" begin="0s"/>
                </circle>
                <circle cx="30" cy="50" fill="#774023" r="20">
                <animate attributeName="cx" repeatCount="indefinite" dur="1s" keyTimes="0;0.5;1" values="30;70;30" begin="-0.5s"/>
                <animate attributeName="fill-opacity" values="0;0;1;1" calcMode="discrete" keyTimes="0;0.499;0.5;1" dur="1s" repeatCount="indefinite"/>
                </circle>
                <!-- [ldio] generated by https://loading.io/ --></svg></div>
            `);
        }

        removeLoadingEffect() {
            var _this = this;
            _this.obj.removeClass('ace-loading');
            _this.obj.find('.ace-loader').remove();
        }

        loadProducts() {
            var _this = this;
            var url = '{{ action('ProductController@widgetProductList') }}';

            _this.addLoadingEffect();

            $.ajax({
                method: "GET",
                url: url,
                data: this.getOptions()
            })
            .done(function( data ) {
                _this.getHtmlContainer().find('products').html(data);

                _this.removeLoadingEffect();

                currentEditor.select(_this);
            });         
        }

        render() {
            var _this = this;

            if (_this.getOptions().preview == 'no') {
                _this.loadPlaceholder();
            } else if (_this.getOptions().preview == 'yes') {
                _this.loadProducts();
            }
        }

        getHtmlContainer() {
            if (!this.obj.find('.container').length) {
                var div = $(`
                    <div>
                        <div class="container">
                            <div class="ace-controls" style="position:relative;display:none">
                                <span class="ace-button preview-but">Preview</span>
                                <span class="ace-button unpreview-but">Close preview</span>
                            </div>
                            <products class="row py-3">
                            </products>
                        </div>
                    <div>
                `)

                this.obj.html(div.html());
            }

            return this.obj.find('.container');
        }

        loadPlaceholder() {
            var _this = this;
            var options = this.getOptions();
            this.getHtmlContainer().find('products').html('');

            for(var i = options.count; i > 0; i--) {
                this.getHtmlContainer().find('products').append(`
                    <div class="col-`+(12/options.cols)+` mb-5">
                        <div class="">
                            <div class="img-col mb-3">
                                <a href="*|PRODUCT_URL|*" class="mr-4"><img src="{{ url('images/product-image-placeholder.svg') }}" width="100%" /></a>
                            </div>
                            <div class="small">
                                <p class="font-weight-normal product-name mb-1">
                                    <a style="color: #333;" href="*|PRODUCT_URL|*" class="mr-4">*|PRODUCT_NAME|*</a>
                                </p>
                                <p class=" product-description">*|PRODUCT_DESCRIPTION|*</p>
                                <p><strong>*|PRODUCT_PRICE|*</strong></p>
                                <a href="*|PRODUCT_URL|*" style="
                                    background-color: #9b5c8f;
                                    border-color: #9b5c8f;" class="btn btn-primary text-white"
                                >
                                    {{ trans('messages.automation.buy_now') }}
                                </a>
                            </div>
                        </div>
                    </div>
                `);
            }

            currentEditor.select(_this);
        }

        addEvents() {
            var element = this;
            var id = element.obj.attr('id');

            if (typeof(window.productListWidgetEvents) == 'undefined') {
                window.productListWidgetEvents = [];
            }

            if (typeof(window.productListWidgetEvents[id]) == 'undefined') {
                window.productListWidgetEvents[id] = true;

                // preview
                element.obj.find('.preview-but').on('click', function() {
                    element.setOptions({
                        preview: 'yes'
                    });

                    console.log('preview');
                });

                // unpreview
                element.obj.find('.unpreview-but').on('click', function() {
                    element.setOptions({
                        preview: 'no'
                    });

                    console.log('unpreview');
                });

                // before save
                currentEditor.addBeforeSaveEvent(function() {
                    element.setOptions({
                        preview: 'no'
                    });
                });
            }
        }

        getControls() {
            var element = this;   
            
            // events
            this.addEvents();

            return [
                new ProductListControl('{{ trans('messages.woo_items.number_of_items') }}', element.getOptions(), {
                    setOptions: function(options) {
                        element.setOptions(options);
                        element.select();
                    }                   
                }),
                new FontFamilyControl(getI18n('font_family'), element.obj.css('font-family'), function(font_family) {
                    element.obj.css('font-family', font_family);
                    element.select();
                }),
                new BackgroundImageControl(getI18n('background_image'), {
                    image: element.obj.css('background-image'),
                    color: element.obj.css('background-color'),
                    repeat: element.obj.css('background-repeat'),
                    position: element.obj.css('background-position'),
                    size: element.obj.css('background-size'),
                }, {
                    setBackgroundImage: function (image) {
                        element.obj.css('background-image', image);
                    },
                    setBackgroundColor: function (color) {
                        element.obj.css('background-color', color);
                    },
                    setBackgroundRepeat: function (repeat) {
                        element.obj.css('background-repeat', repeat);
                    },
                    setBackgroundPosition: function (position) {
                        element.obj.css('background-position', position);
                    },
                    setBackgroundSize: function (size) {
                        element.obj.css('background-size', size);
                    },
                }),
                new BlockOptionControl(getI18n('block_options'), { padding: element.obj.css('padding'), top: element.obj.css('padding-top'), bottom: element.obj.css('padding-bottom'), right: element.obj.css('padding-right'), left: element.obj.css('padding-left') }, function(options) {
                    element.obj.css('padding', options.padding);
                    element.obj.css('padding-top', options.top);
                    element.obj.css('padding-bottom', options.bottom);
                    element.obj.css('padding-right', options.right);
                    element.obj.css('padding-left', options.left);
                    element.select();
                })
            ];
        }
    }
</script>